<?php

#	SonicCampGuard
#
#	Copyright (c) 2024 Bundeswehr
#	Diese Anwendung wurde von Cedric Prietz entwickelt.
#	E-Mail: CedricPrietz@bundeswehr.org
#	App: 90-8303-54618
#
#	Letzte Änderung: 23.09.2024

require_once $_SERVER['DOCUMENT_ROOT'] . '/function.inc.php';
pageName("Dashboard");
requireLogin();
showSessionAlert();
initializeDatabaseConnection();
#requireRole(['Administrator', 'Bearbeiter']);
include($_SERVER['DOCUMENT_ROOT'] . '/header.inc.php');
?>

<div class="d-flex justify-content-between align-items-center flex-wrap grid-margin">
    <div>
        <h4 class="mb-md-0">Dashboard</h4>
        <span class="text-secondary">Willkommen</span>
    </div>
    <div class="d-flex align-items-center flex-wrap text-nowrap">

    </div>
</div>

<div class="alert alert-primary mt-4 mb-4" role="alert">
    <i class="mdi mdi-information-slab-box-outline"></i>
    Einige Funktion sind derzeit nicht verfügbar und werden mit der nächsten Softwarepflege eingeführt.
</div>

<div class="row">

    <div class="col-md-2 grid-margin">
        <div class="card">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-baseline">
                    <h6 class="card-title mb-2">Soldaten</h6>
                </div>
                <h3><?php echo countValidIdentities('Military'); ?></h3>
            </div>
        </div>
    </div>
    <div class="col-md-2 grid-margin">
        <div class="card">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-baseline">
                    <h6 class="card-title mb-2">Zivilisten</h6>
                </div>
                <h3><?php echo countValidIdentities('Civil'); ?></h3>
            </div>
        </div>
    </div>
    <div class="col-md-2 grid-margin">
        <div class="card">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-baseline">
                    <h6 class="card-title mb-2">Ortskräfte</h6>
                </div>
                <h3><?php echo countValidIdentities('Local'); ?></h3>
            </div>
        </div>
    </div>
    <div class="col-md-2 grid-margin">
        <div class="card">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-baseline">
                    <h6 class="card-title mb-2">Gäste</h6>
                </div>
                <h3><?php echo countValidIdentities('Guest'); ?></h3>
            </div>
        </div>
    </div>


    <div class="col-12 col-xl-5 grid-margin">
        <div class="card">
            <div class="card-header">
                <ul class="nav nav-tabs card-header-tabs" id="lineTab" role="tablist">
                    <li class="nav-item">
                        <a class="nav-link active" id="home-line-tab" data-bs-toggle="tab" href="#landing" role="tab"
                            aria-controls="Aktuelle IN" aria-selected="true">IN</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" id="profile-line-tab" data-bs-toggle="tab" href="#takeoff" role="tab"
                            aria-controls="Aktuelle OUT" aria-selected="false">OUT</a>
                    </li>
                </ul>
            </div>
            <div class="card-body">
                <div class="tab-content" id="lineTabContent">
                    <div class="tab-pane show active" id="landing" role="tabpanel" aria-labelledby="home-line-tab">
                        <div class="alert alert-light" role="alert">
                            <i class="mdi mdi-airplane-landing"></i>
                            Bevorstehenden Ankünfte von Soldaten und Zivilisten
                        </div>
                        <table class="table table-bordered">
                            <thead>
                                <tr style="line-height: 20px;">
                                    <th><i class="mdi mdi-account" style="margin-right: .5rem;"></i> Identität</th>
                                    <th width="25%"><i class="mdi mdi-calendar-today" style="margin-right: .5rem;"></i>
                                        Datum</th>
                                    <th width="25%"><i class="mdi mdi-airplane-landing"
                                            style="margin-right: .5rem;"></i> Ankunft</th>
                                </tr>
                            </thead>
                            <?php
                            try {
                                $sql = "
                                        SELECT 
                                            *, 
                                            DATEDIFF(IdentityIN, CURDATE()) AS days_remaining,
                                            CASE
                                                WHEN DATEDIFF(IdentityIN, CURDATE()) = 0 THEN 'Heute'
                                                WHEN DATEDIFF(IdentityIN, CURDATE()) = 1 THEN 'Morgen'
                                                ELSE CONCAT(DATEDIFF(IdentityIN, CURDATE()), ' Tage')
                                            END AS days_display
                                        FROM 
                                            Identities
                                        WHERE 
                                            DATEDIFF(IdentityIN, CURDATE()) BETWEEN 0 AND 10
                                            AND Type IN ('Civil', 'Military')
                                        ORDER BY 
                                            days_remaining ASC
                                    ";

                                $stmt = $pdo->prepare($sql);
                                $stmt->execute();
                                $results = $stmt->fetchAll(PDO::FETCH_ASSOC);

                                if ($results) {
                                    foreach ($results as $row) {
                                        echo "<tr>";
                                        echo "<td>{$row['Rank']} {$row['Surname']}, {$row['Givenname']}</td>";
                                        echo "<td>{$row['IdentityIN']}</td>";
                                        echo "<td>{$row['days_display']}</td>";
                                        echo "</tr>";
                                    }
                                } else {
                                    echo "<td colspan='3'>Keine Ankünfte in den nächsten 10 Tagen.</td>";
                                }
                            } catch (PDOException $e) {
                                echo "Datenbankfehler: " . $e->getMessage();
                            }
                            ?>
                        </table>
                    </div>
                    <div class="tab-pane" id="takeoff" role="tabpanel" aria-labelledby="home-line-tab">
                        <div class="alert alert-light" role="alert">
                            <i class="mdi mdi-airplane-takeoff"></i>
                            Bevorstehenden Abflüge von Soldaten und Zivilisten
                        </div>
                        <table class="table table-bordered">
                            <thead>
                                <tr style="line-height: 20px;">
                                    <th><i class="mdi mdi-account" style="margin-right: .5rem;"></i> Identität</th>
                                    <th width="25%"><i class="mdi mdi-calendar-today" style="margin-right: .5rem;"></i>
                                        Datum</th>
                                    <th width="25%"><i class="mdi mdi-airplane-takeoff"
                                            style="margin-right: .5rem;"></i> Abflug</th>
                                </tr>
                            </thead>
                            <?php
                            try {
                                $sql = "
                                       SELECT 
                                            *, 
                                            DATEDIFF(IdentityOUT, CURDATE()) AS days_remaining,
                                            CASE
                                                WHEN DATEDIFF(IdentityOUT, CURDATE()) = 0 THEN 'Heute'
                                                WHEN DATEDIFF(IdentityOUT, CURDATE()) = 1 THEN 'Morgen'
                                                ELSE CONCAT(DATEDIFF(IdentityOUT, CURDATE()), ' Tage')
                                            END AS days_display
                                        FROM 
                                            Identities
                                        WHERE 
                                            DATEDIFF(IdentityOUT, CURDATE()) BETWEEN 0 AND 10
                                            AND Type IN ('Civil', 'Military')
                                        ORDER BY 
                                            days_remaining ASC
                                    ";

                                $stmt = $pdo->prepare($sql);
                                $stmt->execute();
                                $results = $stmt->fetchAll(PDO::FETCH_ASSOC);

                                if ($results) {

                                    foreach ($results as $row) {
                                        echo "<tr>";
                                        echo "<td>{$row['Rank']} {$row['Surname']}, {$row['Givenname']}</td>";
                                        echo "<td>{$row['IdentityOUT']}</td>";
                                        echo "<td>{$row['days_display']}</td>";
                                        echo "</tr>";
                                    }

                                } else {
                                    echo "<td colspan='3'>Keine Abflüge in den nächsten 10 Tagen.</td>";
                                }
                            } catch (PDOException $e) {
                                echo "Datenbankfehler: " . $e->getMessage();
                            }
                            ?>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

</div>

<?php include($_SERVER['DOCUMENT_ROOT'] . '/footer.inc.php'); ?>